/***************************************************************************
 *   Copyright (C) 2009 by Manuel Schrape                                  *
 *   manuel.schrape@gmx.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "dlg_MotorMixer.h"

dlg_MotorMixer::dlg_MotorMixer(QWidget *parent) : QDialog(parent)
{
    setupUi(this);
    connect(pb_READ, SIGNAL(clicked()), this, SLOT(slot_pb_READ()));
    connect(pb_LOAD, SIGNAL(clicked()), this, SLOT(slot_pb_LOAD()));
    connect(pb_SAVE, SIGNAL(clicked()), this, SLOT(slot_pb_SAVE()));
    connect(pb_WRITE, SIGNAL(clicked()), this, SLOT(slot_pb_WRITE()));

    connect(sb_NICK_1, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_NICK_2, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_NICK_3, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_NICK_4, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_NICK_5, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_NICK_6, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_NICK_7, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_NICK_8, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_NICK_9, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_NICK_10, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_NICK_11, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_NICK_12, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));

    connect(sb_ROLL_1, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_ROLL_2, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_ROLL_3, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_ROLL_4, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_ROLL_5, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_ROLL_6, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_ROLL_7, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_ROLL_8, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_ROLL_9, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_ROLL_10, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_ROLL_11, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_ROLL_12, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));

    connect(sb_GIER_1, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_GIER_2, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_GIER_3, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_GIER_4, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_GIER_5, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_GIER_6, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_GIER_7, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_GIER_8, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_GIER_9, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_GIER_10, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_GIER_11, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));
    connect(sb_GIER_12, SIGNAL(valueChanged(int)), this, SLOT(slot_CheckValue(int)));

}

// Connection-Object übergeben.
void dlg_MotorMixer::set_Objects(cConnection *t_Connection, cSettings *t_Settings)
{
    o_Connection = t_Connection;
    o_Settings   = t_Settings;
}

// Motordaten übernehmen.
void dlg_MotorMixer::set_MotorConfig(sRxData RX)
{
    int Pos = 0;

    MixerName = ToolBox::Data2QString(RX.Decode, 1, 12);

    Pos = 13;

    for (int z = 0; z < 16; z++)
    {
        for (int y = 0; y < 4; y++)
        {
            Motor[z][y] = ToolBox::Data2Char(RX.Decode,Pos);
            Pos++;
        }
    }

    set_MotorData();
}

// Motordaten aus GUI übernehmen
void dlg_MotorMixer::get_MotorData()
{
    MixerName = le_NAME->text();

    Motor[0][0]  = sb_GAS_1->value();
    Motor[1][0]  = sb_GAS_2->value();
    Motor[2][0]  = sb_GAS_3->value();
    Motor[3][0]  = sb_GAS_4->value();
    Motor[4][0]  = sb_GAS_5->value();
    Motor[5][0]  = sb_GAS_6->value();
    Motor[6][0]  = sb_GAS_7->value();
    Motor[7][0]  = sb_GAS_8->value();
    Motor[8][0]  = sb_GAS_9->value();
    Motor[9][0]  = sb_GAS_10->value();
    Motor[10][0] = sb_GAS_11->value();
    Motor[11][0] = sb_GAS_12->value();

    Motor[0][1]  = sb_NICK_1->value();
    Motor[1][1]  = sb_NICK_2->value();
    Motor[2][1]  = sb_NICK_3->value();
    Motor[3][1]  = sb_NICK_4->value();
    Motor[4][1]  = sb_NICK_5->value();
    Motor[5][1]  = sb_NICK_6->value();
    Motor[6][1]  = sb_NICK_7->value();
    Motor[7][1]  = sb_NICK_8->value();
    Motor[8][1]  = sb_NICK_9->value();
    Motor[9][1]  = sb_NICK_10->value();
    Motor[10][1] = sb_NICK_11->value();
    Motor[11][1] = sb_NICK_12->value();

    Motor[0][2]  = sb_ROLL_1->value();
    Motor[1][2]  = sb_ROLL_2->value();
    Motor[2][2]  = sb_ROLL_3->value();
    Motor[3][2]  = sb_ROLL_4->value();
    Motor[4][2]  = sb_ROLL_5->value();
    Motor[5][2]  = sb_ROLL_6->value();
    Motor[6][2]  = sb_ROLL_7->value();
    Motor[7][2]  = sb_ROLL_8->value();
    Motor[8][2]  = sb_ROLL_9->value();
    Motor[9][2]  = sb_ROLL_10->value();
    Motor[10][2] = sb_ROLL_11->value();
    Motor[11][2] = sb_ROLL_12->value();

    Motor[0][3]  = sb_GIER_1->value();
    Motor[1][3]  = sb_GIER_2->value();
    Motor[2][3]  = sb_GIER_3->value();
    Motor[3][3]  = sb_GIER_4->value();
    Motor[4][3]  = sb_GIER_5->value();
    Motor[5][3]  = sb_GIER_6->value();
    Motor[6][3]  = sb_GIER_7->value();
    Motor[7][3]  = sb_GIER_8->value();
    Motor[8][3]  = sb_GIER_9->value();
    Motor[9][3]  = sb_GIER_10->value();
    Motor[10][3] = sb_GIER_11->value();
    Motor[11][3] = sb_GIER_12->value();
}

// Motordaten anzeigen
void dlg_MotorMixer::set_MotorData()
{
    le_NAME->setText(MixerName);

    sb_GAS_1->setValue(Motor[0][0]);
    sb_GAS_2->setValue(Motor[1][0]);
    sb_GAS_3->setValue(Motor[2][0]);
    sb_GAS_4->setValue(Motor[3][0]);
    sb_GAS_5->setValue(Motor[4][0]);
    sb_GAS_6->setValue(Motor[5][0]);
    sb_GAS_7->setValue(Motor[6][0]);
    sb_GAS_8->setValue(Motor[7][0]);
    sb_GAS_9->setValue(Motor[8][0]);
    sb_GAS_10->setValue(Motor[9][0]);
    sb_GAS_11->setValue(Motor[10][0]);
    sb_GAS_12->setValue(Motor[11][0]);

    sb_NICK_1->setValue(Motor[0][1]);
    sb_NICK_2->setValue(Motor[1][1]);
    sb_NICK_3->setValue(Motor[2][1]);
    sb_NICK_4->setValue(Motor[3][1]);
    sb_NICK_5->setValue(Motor[4][1]);
    sb_NICK_6->setValue(Motor[5][1]);
    sb_NICK_7->setValue(Motor[6][1]);
    sb_NICK_8->setValue(Motor[7][1]);
    sb_NICK_9->setValue(Motor[8][1]);
    sb_NICK_10->setValue(Motor[9][1]);
    sb_NICK_11->setValue(Motor[10][1]);
    sb_NICK_12->setValue(Motor[11][1]);

    sb_ROLL_1->setValue(Motor[0][2]);
    sb_ROLL_2->setValue(Motor[1][2]);
    sb_ROLL_3->setValue(Motor[2][2]);
    sb_ROLL_4->setValue(Motor[3][2]);
    sb_ROLL_5->setValue(Motor[4][2]);
    sb_ROLL_6->setValue(Motor[5][2]);
    sb_ROLL_7->setValue(Motor[6][2]);
    sb_ROLL_8->setValue(Motor[7][2]);
    sb_ROLL_9->setValue(Motor[8][2]);
    sb_ROLL_10->setValue(Motor[9][2]);
    sb_ROLL_11->setValue(Motor[10][2]);
    sb_ROLL_12->setValue(Motor[11][2]);

    sb_GIER_1->setValue(Motor[0][3]);
    sb_GIER_2->setValue(Motor[1][3]);
    sb_GIER_3->setValue(Motor[2][3]);
    sb_GIER_4->setValue(Motor[3][3]);
    sb_GIER_5->setValue(Motor[4][3]);
    sb_GIER_6->setValue(Motor[5][3]);
    sb_GIER_7->setValue(Motor[6][3]);
    sb_GIER_8->setValue(Motor[7][3]);
    sb_GIER_9->setValue(Motor[8][3]);
    sb_GIER_10->setValue(Motor[9][3]);
    sb_GIER_11->setValue(Motor[10][3]);
    sb_GIER_12->setValue(Motor[11][3]);
}

// Prüfen auf vollstaändigkeit
void dlg_MotorMixer::slot_CheckValue(int Wert)
{
    Wert = Wert;

    int NICK = sb_NICK_1->value() + sb_NICK_2->value() + sb_NICK_3->value() + sb_NICK_4->value() + sb_NICK_5->value() + sb_NICK_6->value() +
               sb_NICK_7->value() + sb_NICK_8->value() + sb_NICK_9->value() + sb_NICK_10->value() + sb_NICK_11->value() + sb_NICK_12->value();

    int ROLL = sb_ROLL_1->value() + sb_ROLL_2->value() + sb_ROLL_3->value() + sb_ROLL_4->value() + sb_ROLL_5->value() + sb_ROLL_6->value() +
               sb_ROLL_7->value() + sb_ROLL_8->value() + sb_ROLL_9->value() + sb_ROLL_10->value() + sb_ROLL_11->value() + sb_ROLL_12->value();

    int GIER = sb_GIER_1->value() + sb_GIER_2->value() + sb_GIER_3->value() + sb_GIER_4->value() + sb_GIER_5->value() + sb_GIER_6->value() +
               sb_GIER_7->value() + sb_GIER_8->value() + sb_GIER_9->value() + sb_GIER_10->value() + sb_GIER_11->value() + sb_GIER_12->value();

    if (NICK == 0)
    {
        lb_NICK->setEnabled(true);
    }
    else
    {
        lb_NICK->setEnabled(false);
    }

    if (ROLL == 0)
    {
        lb_ROLL->setEnabled(true);
    }
    else
    {
        lb_ROLL->setEnabled(false);
    }

    if (GIER == 0)
    {
        lb_GIER->setEnabled(true);
    }
    else
    {
        lb_GIER->setEnabled(false);
    }
}

int dlg_MotorMixer::get_MotorConfig()
{
    get_MotorData();

    TX_Data[0] = VERSION_MIXER;

    char *Name = MixerName.toLatin1().data();

    int a;

    for (a = 0; a < MixerName.length(); a++)
    {
        TX_Data[1+a] = Name[a];
    }

    while(a < 12)
    {
        TX_Data[1+a] = 0;
        a++;
    }

    int Pos = 13;

    for (int z = 0; z < 16; z++)
    {
        for (int y = 0; y < 4; y++)
        {
            TX_Data[Pos] = ToolBox::Char2Data(Motor[z][y]);
            Pos++;
        }
    }

    return Pos - 1;
}

void dlg_MotorMixer::read_Mixer()
{
    TX_Data[0] = 0;
    o_Connection->send_Cmd('n', ADDRESS_FC, TX_Data, 1, true);
}

// Motordaten auslesen
void dlg_MotorMixer::slot_pb_READ()
{
    TX_Data[0] = 0;
    o_Connection->send_Cmd('n', ADDRESS_FC, TX_Data, 1, true);
}

void dlg_MotorMixer::slot_pb_WRITE()
{
    int Length = get_MotorConfig();
    o_Connection->send_Cmd('m', ADDRESS_FC, TX_Data, Length, true);
}

void dlg_MotorMixer::slot_pb_LOAD()
{
    QString Filename = QFileDialog::getOpenFileName(this, tr("Mikrokopter MotorMixer laden"),  o_Settings->DIR.Parameter + "", tr("MK MotorMixer(*.mkm);;Alle Dateien (*)"));

    if (!Filename.isEmpty())
    {
        QSettings Setting(Filename, QSettings::IniFormat);

        Setting.beginGroup("Info");
            MixerName    = Setting.value("Name", QString("--noname--")).toString();
            MixerVersion = Setting.value("Version", 0).toInt();
        Setting.endGroup();

        Setting.beginGroup("Gas");
            for (int z = 0; z < MAXMOTOR; z++)
            {
                Motor[z][0] = Setting.value(QString("Motor%1").arg(z+1), 0).toInt();
            }
        Setting.endGroup();

        Setting.beginGroup("Nick");
            for (int z = 0; z < MAXMOTOR; z++)
            {
                Motor[z][1] = Setting.value(QString("Motor%1").arg(z+1), 0).toInt();
            }
        Setting.endGroup();

        Setting.beginGroup("Roll");
            for (int z = 0; z < MAXMOTOR; z++)
            {
                Motor[z][2] = Setting.value(QString("Motor%1").arg(z+1), 0).toInt();
            }
        Setting.endGroup();

        Setting.beginGroup("Yaw");
            for (int z = 0; z < MAXMOTOR; z++)
            {
                Motor[z][3] = Setting.value(QString("Motor%1").arg(z+1), 0).toInt();
            }
        Setting.endGroup();

        if (MixerVersion == VERSION_MIXER)
        {
            set_MotorData();
        }
    }
}

void dlg_MotorMixer::slot_pb_SAVE()
{
    QString Filename = QFileDialog::getSaveFileName(this, tr("Mikrokopter MotorMixer speichern"), o_Settings->DIR.Parameter + "/" + le_NAME->text(), tr("MK MotorMixer(*.mkm);;Alle Dateien (*)"));

    if (!Filename.isEmpty())
    {
        if (!(Filename.endsWith(".mkm", Qt::CaseInsensitive)))
        {
            Filename = Filename + QString(".mkm");
        }

        get_MotorData();

        QSettings Setting(Filename, QSettings::IniFormat);

        Setting.beginGroup("Info");
            Setting.setValue("Name",         MixerName);
            Setting.setValue("Version",      VERSION_MIXER);
        Setting.endGroup();

        Setting.beginGroup("Gas");
            for (int z = 0; z < MAXMOTOR; z++)
            {
                Setting.setValue(QString("Motor%1").arg(z+1), Motor[z][0]);
            }
        Setting.endGroup();

        Setting.beginGroup("Nick");
            for (int z = 0; z < MAXMOTOR; z++)
            {
                 Setting.setValue(QString("Motor%1").arg(z+1), Motor[z][1]);
            }
        Setting.endGroup();

        Setting.beginGroup("Roll");
            for (int z = 0; z < MAXMOTOR; z++)
            {
                Setting.setValue(QString("Motor%1").arg(z+1), Motor[z][2]);
            }
        Setting.endGroup();

        Setting.beginGroup("Yaw");
            for (int z = 0; z < MAXMOTOR; z++)
            {
                Setting.setValue(QString("Motor%1").arg(z+1), Motor[z][3]);
            }
        Setting.endGroup();
    }
}
